<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Registration</title>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">

    <style>
        body {
            background-color: #0d6efd; /* full blue background */
        }
        .card {
            border-radius: 10px;
        }
    </style>
</head>
<body>

<div class="container-fluid">

    <!-- Header -->
    <div class="row bg-dark p-3">
        <div class="col">
            <h3 class="text-white mb-0">Laravel Project</h3>
        </div>
    </div>

    <!-- Content -->
    <div class="row py-5 justify-content-center">

        <!-- Registration Form -->
        <div class="col-md-5">
            <div class="card p-4 shadow">
                <h3 class="mb-4 text-center">Student Registration</h3>

                <form method="post">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>

                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" class="form-control" name="email" required>
                    </div>

                    <div class="form-group">
                        <label>Phone</label>
                        <input type="tel" class="form-control" name="phone" required>
                    </div>

                    <div class="form-group">
                        <label>Address</label>
                        <textarea class="form-control" name="address" rows="3" required></textarea>
                    </div>

                    <div class="form-group">
                        <label>Gender</label>
                        <select class="form-control" name="gender" required>
                            <option value="">-- Select Gender --</option>
                            <option>Male</option>
                            <option>Female</option>
                            <option>Other</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Department</label>
                        <input type="text" class="form-control" name="department" required>
                    </div>

                    <div class="form-check mb-3">
                        <input type="checkbox" class="form-check-input" name="parttime">
                        <label class="form-check-label">Part-time Student</label>
                    </div>

                    <div class="form-group">
                        <label>Joined Date</label>
                        <input type="date" class="form-control" name="joined_date" required>
                    </div>

                    <button type="submit" class="btn btn-dark btn-block">Submit</button>
                </form>
            </div>
        </div>

        <!-- Registered Students -->
        <div class="col-md-5">
            <div class="card p-4 shadow">
                <h3 class="mb-4 text-center">Registered Students</h3>

                <ul class="list-group">
                    <li class="list-group-item">Sanjeev - sanjeev@example.com - 2026-01-04</li>
                    <li class="list-group-item">Theva - theva@example.com - 2026-01-04</li>
                    <li class="list-group-item">Kathu - kathu@example.com - 2026-01-04</li>
                    <li class="list-group-item">Baga - baga@example.com - 2026-01-04</li>
                    <li class="list-group-item">Seran - seran@example.com - 2026-01-04</li>
                </ul>
            </div>
        </div>

    </div>
</div>

</body>
</html>
